uniform sampler2D uni_is_tex ;

/// The filter kernel width
uniform float uni_f_filter_width ;

/// The filter kernel height
uniform float uni_f_filter_height ;

/// The reciprocal width of the incomming texture.
uniform float uni_f_recip_width ;
uniform float uni_f_recip_height ;

const float weight = 1.0 / 24.0 ;

void main()
{


	vec2 step_half = vec2(uni_f_recip_width,uni_f_recip_height) * vec2(0.5) ;
	
	vec4 color = vec4(0) ;

	// inner four
	color += 3.0*texture2D(uni_is_tex, gl_TexCoord[0].xy + step_half * vec2(-1.0,-1.0) ) ;
	color += 2.0*texture2D(uni_is_tex, gl_TexCoord[0].xy + step_half * vec2(-1.0,1.0) ) ;
	color += 3.0*texture2D(uni_is_tex, gl_TexCoord[0].xy + step_half * vec2(1.0,1.0) ) ;
	color += 2.0*texture2D(uni_is_tex, gl_TexCoord[0].xy + step_half * vec2(1.0,-1.0) ) ;
	
	// top four 
	color += texture2D(uni_is_tex, gl_TexCoord[0].xy + step_half * vec2(-3.0,3.0) ) ;
	color += texture2D(uni_is_tex, gl_TexCoord[0].xy + step_half * vec2(-1.0,3.0) ) ;
	color += texture2D(uni_is_tex, gl_TexCoord[0].xy + step_half * vec2(1.0,3.0) ) ;
	color += texture2D(uni_is_tex, gl_TexCoord[0].xy + step_half * vec2(3.0,3.0) ) ;

	// bottom four

	color += texture2D(uni_is_tex, gl_TexCoord[0].xy + step_half * vec2(-3.0,-3.0) ) ;
	color += texture2D(uni_is_tex, gl_TexCoord[0].xy + step_half * vec2(-1.0,-3.0) ) ;
	color += texture2D(uni_is_tex, gl_TexCoord[0].xy + step_half * vec2(1.0,-3.0) ) ;
	color += texture2D(uni_is_tex, gl_TexCoord[0].xy + step_half * vec2(3.0,-3.0) ) ;

	// left

	color += texture2D(uni_is_tex, gl_TexCoord[0].xy + step_half * vec2(-3.0,1.0) ) ;
	color += texture2D(uni_is_tex, gl_TexCoord[0].xy + step_half * vec2(-3.0,-1.0) ) ;

	// right

	color += texture2D(uni_is_tex, gl_TexCoord[0].xy + step_half * vec2(3.0,1.0) ) ;
	color += texture2D(uni_is_tex, gl_TexCoord[0].xy + step_half * vec2(3.0,-1.0) ) ;
	

	gl_FragData[0] = color * vec4(weight) ;
	
	// Here the other
	gl_FragData[1] = vec4(0.0) ;
}

// void main()
// {
// 	vec4 op1 = vec4(
// 		uni_f_filter_width,
// 		uni_f_filter_height,
// 		uni_f_filter_width,
// 		uni_f_filter_height
// 	) ;
// 
// 	vec4 op2 = vec4(
// 		0.5,
// 		0.5,
// 		uni_f_filter_height,
// 		uni_f_filter_width
// 	) ;
// 
// 	vec4 res = op1 * op2 ;
// 
// 	//float half_width = uni_f_filter_width * 0.5 ;
// 	//float half_height = uni_f_filter_height * 0.5 ;
// 
// 	float half_width = res.x ;
// 	float half_height = res.y ;
// 
// 	//float weight = 1.0 / (uni_f_filter_width * uni_f_filter_height) ;
// 	float weight = 1.0 / res.z ; 
// 
// 	float start_x = gl_TexCoord[0].x - (half_width*uni_f_recip_width) ;
// 	float start_y = gl_TexCoord[0].y - (half_height*uni_f_recip_height) ;
// 
// 	float end_x = gl_TexCoord[0].x + (half_width*uni_f_recip_width) ;
// 	float end_y = gl_TexCoord[0].y + (half_height*uni_f_recip_height) ;
// 
// 	vec4 color = vec4(0) ;
// 
// 	for( float y=start_y; y<end_y; y+=uni_f_recip_height )
// 	{
// 		for( float x=start_x; x<end_x; x+=uni_f_recip_width )
// 		{
// 			color += texture2D(uni_is_tex, vec2(x,y) ) ;
// 		}
// 	}
// 
// 	gl_FragColor = color * vec4(weight) ;
// }